<{* Publisher Custom Template - Temel Görünüm *}>

<{if $publisher_count > 0}>
    <div class="publisher-custom-block">
        <{foreach item=item from=$publisher_items}>
            <div class="publisher-item">
                <{if $item.image}>
                    <div class="publisher-item-image">
                        <a href="<{$item.link}>" title="<{$item.title}>">
                            <img src="<{$item.thumb}>" alt="<{$item.title}>" />
                        </a>
                    </div>
                <{/if}>
                
                <div class="publisher-item-content">
                    <h3 class="publisher-item-title">
                        <a href="<{$item.link}>" title="<{$item.title}>">
                            <{$item.title}>
                        </a>
                    </h3>
                    
                    <{if $item.subtitle}>
                        <div class="publisher-item-subtitle">
                            <{$item.subtitle}>
                        </div>
                    <{/if}>
                    
                    <div class="publisher-item-meta">
                        <span class="publisher-date">
                            <i class="fa fa-calendar"></i> <{$item.date_short}>
                        </span>
                        
                        <span class="publisher-author">
                            <i class="fa fa-user"></i> 
                            <{if $item.author_link}>
                                <a href="<{$item.author_link}>"><{$item.author_name}></a>
                            <{else}>
                                <{$item.author_name}>
                            <{/if}>
                        </span>
                        
                        <span class="publisher-counter">
                            <i class="fa fa-eye"></i> <{$item.counter}>
                        </span>
                        
                        <{if $item.votes > 0}>
                            <span class="publisher-rating">
                                <i class="fa fa-star"></i> <{$item.rating}>/5 (<{$item.votes}> oy)
                            </span>
                        <{/if}>
                    </div>
                    
                    <{if $item.summary}>
                        <div class="publisher-item-summary">
                            <{$item.summary}>
                        </div>
                    <{/if}>
                    
                    <div class="publisher-item-readmore">
                        <a href="<{$item.link}>" class="btn btn-primary">Devamını Oku</a>
                    </div>
                </div>
            </div>
        <{/foreach}>
    </div>
<{else}>
    <div class="publisher-no-items">
        <p>Henüz içerik bulunmamaktadır.</p>
    </div>
<{/if}>

<style>
.publisher-custom-block {
    margin: 20px 0;
}

.publisher-item {
    margin-bottom: 30px;
    padding: 20px;
    border: 1px solid #e0e0e0;
    border-radius: 5px;
    background: #fff;
}

.publisher-item-image {
    float: left;
    margin-right: 20px;
    margin-bottom: 10px;
}

.publisher-item-image img {
    max-width: 200px;
    height: auto;
    border-radius: 5px;
}

.publisher-item-content {
    overflow: hidden;
}

.publisher-item-title {
    margin: 0 0 10px 0;
    font-size: 24px;
}

.publisher-item-title a {
    color: #333;
    text-decoration: none;
}

.publisher-item-title a:hover {
    color: #0066cc;
}

.publisher-item-subtitle {
    margin-bottom: 10px;
    color: #666;
    font-style: italic;
}

.publisher-item-meta {
    margin-bottom: 15px;
    padding: 10px 0;
    border-top: 1px solid #f0f0f0;
    border-bottom: 1px solid #f0f0f0;
    font-size: 13px;
    color: #777;
}

.publisher-item-meta span {
    margin-right: 15px;
}

.publisher-item-summary {
    margin-bottom: 15px;
    line-height: 1.6;
}

.publisher-item-readmore a {
    display: inline-block;
    padding: 8px 20px;
    background: #0066cc;
    color: #fff;
    text-decoration: none;
    border-radius: 3px;
}

.publisher-item-readmore a:hover {
    background: #0052a3;
}

.publisher-no-items {
    padding: 40px;
    text-align: center;
    color: #999;
}
</style>
